Imports System.Web.Services
Imports System.Web.Services.Protocols

<System.Web.Services.WebService(Namespace:="http://RectangleService/RectangleService")> _
Public Class RectangleService
    Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Web Services Designer.
        InitializeComponent()

        'Add your own initialization code after the InitializeComponent() call

    End Sub

    'Required by the Web Services Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Web Services Designer
    'It can be modified using the Web Services Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        'CODEGEN: This procedure is required by the Web Services Designer
        'Do not modify it using the code editor.
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

#End Region

    Public AuthInfo As AuthenticationHeader

    <WebMethod(), SoapHeader("AuthInfo", _
        Direction:=SoapHeaderDirection.InOut)> _
    Public Function Area(ByVal Length As Double, ByVal Width As Double) As Double
        ' TODO Verify username and password against database
        If AuthInfo.UserName <> "user" Or _
            AuthInfo.Password <> "password" Then
            Throw New SoapException("Invalid Credentials", SoapException.ClientFaultCode)
        End If
        Return Length * Width
    End Function

    <WebMethod()> _
    Public Function Perimeter(ByVal Length As Double, ByVal Width As Double) As Double
        Return 2 * (Length + Width)
    End Function

    <WebMethod(CacheDuration:=30, _
        Description:="Method that uses caching", _
        MessageName:="CachedTime")> _
    Public Function CachedMethod() As String
        Return "The time is " & _
        DateTime.Now.ToLongTimeString()
    End Function

    <WebMethod(EnableSession:=True)> _
    Public Function StoreUser(ByVal User As String) As Boolean
        Session("User") = User
        Return True
    End Function

    <WebMethod(EnableSession:=True)> _
    Public Function RetrieveUser() As String
        If Not Session("User") Is Nothing Then
            Return Session("User").ToString()
        Else
            Return ""
        End If
    End Function

End Class
